// Title      : NewsClient.java
// Author     : James Baird
// Created    : Monday, 13th November 2000
// Description: NewsClient Class

import com.oroinc.net.nntp.NewsgroupInfo;
import com.oroinc.net.nntp.NNTPClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class NewsClient extends NNTPClient
{
  public boolean setNewsgroup(String newsgroup, NewsgroupInfo info) throws IOException
  {
    this.newsgroup = newsgroup;

    return selectNewsgroup(newsgroup, info);
  }

  public Post getPost(int article) throws IOException
  {
    Post post = null;

    Vector header = getPostHeader(article);

    if (header != null)
    {
      Vector body = getPostBody(article);

      if (body != null)
        post = new Post(newsgroup, article, header, body);
    }

    return post;
  }

  public Vector getPostHeader(int i) throws IOException
  {
    return readerToVector(this.retrieveArticleHeader(i));
  }
  
  public Vector getPostBody(int i) throws IOException
  {
    return readerToVector(this.retrieveArticleBody(i));
  }
  
  protected Vector readerToVector(Reader reader) throws IOException
  {
    if (reader == null)
      return null;
    else
    {
      Vector result = new Vector();
    
      BufferedReader bufferedReader = new BufferedReader(reader);

      String line;

      while ((line = bufferedReader.readLine()) != null)
      {
        result.addElement(filter(line));
      }

      bufferedReader.close();

      return result;
    }
  }
  
  protected String filter(String s)
  {
    byte[] bytes = s.getBytes();
    
    for (int i = 0; i < bytes.length; i++)
    {
      if (bytes[i] > 0x7e)
        bytes[i] = 0x20;
        
      if (bytes[i] < 0x20)
        bytes[i] = 0x20;
    }
  
    return new String(bytes);
  }

  String newsgroup;
}
